function [beta,RSS,sigma,AIC,res]=diagnostics(y,p,d,r,R)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 6.2
% file: diagnostics.m
% coded by Dong Li
%
% Given p, d, r and R to estimate the coefficients, the sum of squred
% residuals, the variances in each regime and AIC.
% p=[p1,p2,p3] The order in each regime.
% r and R are thresholds;
% The total number of the output is sum(p+1)+1+3+1=sum(p+1)+5;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n     = length(y);
m     = max(max(p),d);
[Y,A] = designmatrix(y,m);

I1 = (y(m+1-d:n-d)<r*ones(n-m,1)); % The indicators function;
I2 = (r*ones(n-m,1)<y(m+1-d:n-d) &y(m+1-d:n-d)<R*ones(n-m,1));
I3 = (y(m+1-d:n-d)>R*ones(n-m,1));

X1 = Y.*I1;
X2 = Y.*I2;
X3 = Y.*I3;
D1 = A(:,1:1+p(1)).*(I1*ones(1,1+p(1)));
D2 = A(:,1:1+p(2)).*(I2*ones(1,1+p(2)));
D3 = A(:,1:1+p(3)).*(I3*ones(1,1+p(3)));

beta1 = inv(D1'*D1)*(D1'*X1);
beta2 = inv(D2'*D2)*(D2'*X2);
beta3 = inv(D3'*D3)*(D3'*X3);
beta  = [beta1',beta2',beta3'];

RSS=((X1-D1*beta1)'*(X1-D1*beta1)+(X2-D2*beta2)'*(X2-D2*beta2)+(X3-D3*beta3)'*(X3-D3*beta3))/(n-m);
sigma1 = (X1-D1*beta1)'*(X1-D1*beta1)/sum(I1);
sigma2 = (X2-D2*beta2)'*(X2-D2*beta2)/sum(I2);
sigma3 = (X3-D3*beta3)'*(X3-D3*beta3)/sum(I3);
sigma  = [sigma1,sigma2,sigma3];

AIC = sum(I1)*log(sigma1)+sum(I2)*log(sigma2)+sum(I3)*log(sigma3)+2*(sum(p+1));
res = (X1-D1*beta1)/sqrt(sigma1)+(X2-D2*beta2)/sqrt(sigma2)+(X3-D3*beta3)/sqrt(sigma3);
